//=============================================================================
// WeaponPhotonTacticalShotgun.
//=============================================================================
class WeaponPhotonTacticalShotgunF extends PhotonWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
	}
}

//
// functions to change ammo types
//
function bool LoadAmmo(int ammoNum)
{
	local class<Ammo> newAmmoClass;
	local Ammo newAmmo;
	local Pawn P;

	if ((ammoNum < 0) || (ammoNum > 2))
		return False;

	P = Pawn(Owner);

	// sorry, only pawns can have weapons
	if (P == None)
		return False;

	newAmmoClass = AmmoNames[ammoNum];

	if (newAmmoClass != None)
	{
		if (newAmmoClass != AmmoName)
		{
			newAmmo = Ammo(P.FindInventoryType(newAmmoClass));
			if (newAmmo == None)
			{
				P.ClientMessage(Sprintf(msgOutOf, newAmmoClass.Default.ItemName));
				return False;
			}
			
			// if we don't have a projectile for this ammo type, then set instant hit
			if (ProjectileNames[ammoNum] == None)
			{
				bInstantHit = True;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if ( Level.NetMode != NM_Standalone )
				{
					if (HasReloadMod())
						ReloadTime = mpReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = mpReloadTime;
				}
				else
				{
					if (HasReloadMod())
						ReloadTime = Default.ReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = Default.ReloadTime;
				}
				FireSound = Default.FireSound;
				ProjectileClass = None;
			}
			else
			{
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

				// otherwise, set us to fire projectiles
				bInstantHit = False;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if (HasReloadMod())
					ReloadTime = 2.0 * (1.0+ModReloadTime);
				else
					ReloadTime = 2.0;
				FireSound = Default.FireSound;		// handled by the projectile
				ProjectileClass = ProjectileNames[ammoNum];
				ProjectileSpeed = ProjectileClass.Default.Speed;

				if ( AmmoGreenPhoton(newAmmo) != None )
                                        {
                                        bAutomatic = Default.bAutomatic;
                                        ShotTime = Default.ShotTime;
                                        ReloadCount = Default.ReloadCount;
                                        FireSound = Default.FireSound;
                                        }
				if ( AmmoOrangePhoton(newAmmo) != None )
                                        {
                                        bAutomatic = Default.bAutomatic;
                                        ShotTime = Default.ShotTime;
                                        ReloadCount = Default.ReloadCount;
                                        FireSound = Default.FireSound;
                                        }
                                }
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

			// AlexB had a new sound for 20mm but there's no mechanism for playing alternate sounds per ammo type
			// Same for WP rocket
			if ( Ammo20mm(newAmmo) != None )
				FireSound=Sound'AssaultGunFire20mm';
			else if ( AmmoRocketWP(newAmmo) != None )
				FireSound=Sound'GEPGunFireWP';
			else if ( AmmoRocket(newAmmo) != None )
				FireSound=Sound'GEPGunFire';

			if ( Level.NetMode != NM_Standalone )
				SetClientAmmoParams( bInstantHit, bAutomatic, ShotTime, FireSound, ProjectileClass, ProjectileSpeed );

			// Notify the object belt of the new ammo
			if (DeusExPlayer(P) != None)
				DeusExPlayer(P).UpdateBeltText(Self);

			ReloadAmmo();

			P.ClientMessage(Sprintf(msgNowHas, ItemName, newAmmoClass.Default.ItemName));
			return True;
		}
		else
		{
			P.ClientMessage(Sprintf(MsgAlreadyHas, ItemName, newAmmoClass.Default.ItemName));
		}
	}
	return False;
}

function Tick(float DeltaTime)
{
 local bool bFixed;

 Super.Tick(DeltaTime);

 if (FireSound != Sound'PhotonAutoShotgunFire')
  bFixed = False;

 if (!bFixed)
  FireSound = Sound'PhotonAutoShotgunFire';
}

//simulated function SwapMuzzleFlashTexture()
//{
//   	if ( !bHasMuzzleFlash )
//      		return;  
//
//	MultiSkins[2] = Texture'GreenLaserSpot';
//	SetTimer(0.2, False);
//}

defaultproperties
{
     NumBarrels=Num_Quintuple
     LowAmmoWaterMark=12
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     bAutomatic=True
     ShotTime=0.700000
     reloadTime=3.500000
     maxRange=5000
     AccurateRange=2500
     BaseAccuracy=0.800000
     bCanHaveLaser=True
     bHasLaser=True
     AmmoNames(0)=Class'Markistan.AmmoGreenPhoton'
     AmmoNames(1)=Class'Markistan.AmmoOrangePhoton'
     ProjectileNames(0)=Class'Markistan.GreenPhotonBlast'
     ProjectileNames(1)=Class'Markistan.OrangePhotonBlast'
     AreaOfEffect=AOE_Cone
     recoilStrength=0.800000
     mpReloadTime=0.500000
     mpHitDamage=5
     mpBaseAccuracy=0.200000
     mpAccurateRange=1800
     mpMaxRange=1800
     mpReloadCount=20
     bCanHaveModRecoilStrength=True
     AmmoName=Class'Markistan.AmmoGreenPhoton'
     ReloadCount=20
     PickupAmmoCount=60
     FireOffset=(X=-30.000000,Y=10.000000,Z=12.000000)
     ProjectileClass=Class'Markistan.GreenPhotonBlast'
     shakemag=50.000000
     FireSound=Sound'Markistan.Weapons.PhotonAutoShotgunFire'
     AltFireSound=Sound'DeusExSounds.Weapons.AssaultShotgunReloadEnd'
     CockingSound=Sound'DeusExSounds.Weapons.AssaultShotgunReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultShotgunSelect'
     InventoryGroup=176
     ItemName="|p3XB-29 Photon Tactical Shotgun"
     ItemArticle="an"
     PlayerViewOffset=(Y=-10.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.AssaultShotgun'
     PickupViewMesh=LodMesh'DeusExItems.AssaultShotgunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.AssaultShotgun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconAssaultShotgun'
     largeIcon=Texture'DeusExUI.Icons.LargeIconAssaultShotgun'
     largeIconWidth=99
     largeIconHeight=55
     invSlotsX=4
     invSlotsY=2
     Description="The Tactical upgraded and revamped so its fires unstable green and orange photons, this one is the default version and does not have an attached red photon bomb launcher."
     beltDescription="|p3XB-29"
     Mesh=LodMesh'DeusExItems.AssaultShotgunPickup'
     CollisionRadius=15.000000
     CollisionHeight=8.000000
     Mass=50.000000
}
